/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.Database;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.Variable;
import com.mckoi.util.IntegerVector;
import java.io.PrintStream;

public class FilterTable
extends Table {
    protected Table parent;
    private SelectableScheme[] column_scheme;

    public FilterTable(Table parent) {
        this.parent = parent;
    }

    protected Table getParent() {
        return this.parent;
    }

    public Database getDatabase() {
        return this.parent.getDatabase();
    }

    public int getColumnCount() {
        return this.parent.getColumnCount();
    }

    public int getRowCount() {
        return this.parent.getRowCount();
    }

    public int findFieldName(Variable v) {
        return this.parent.findFieldName(v);
    }

    public Variable getResolvedVariable(int column) {
        return this.parent.getResolvedVariable(column);
    }

    SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        SelectableScheme scheme;
        if (this.column_scheme == null) {
            this.column_scheme = new SelectableScheme[this.parent.getColumnCount()];
        }
        if ((scheme = this.column_scheme[column]) == null) {
            Table t = table;
            if (table == this) {
                t = this.parent;
            }
            scheme = this.parent.getSelectableSchemeFor(column, original_column, t);
            if (table == this) {
                this.column_scheme[column] = scheme;
            }
        } else {
            if (table == this) {
                return scheme;
            }
            return scheme.getSubsetScheme(table, original_column);
        }
        return scheme;
    }

    void setToRowTableDomain(int column, IntegerVector row_set, TableDataSource ancestor) {
        if (ancestor == this || ancestor == this.parent) {
            return;
        }
        this.parent.setToRowTableDomain(column, row_set, ancestor);
    }

    RawTableInformation resolveToRawTable(RawTableInformation info) {
        return this.parent.resolveToRawTable(info);
    }

    public TObject getCellContents(int column, int row) {
        return this.parent.getCellContents(column, row);
    }

    public RowEnumeration rowEnumeration() {
        return this.parent.rowEnumeration();
    }

    public DataTableDef getDataTableDef() {
        return this.parent.getDataTableDef();
    }

    void addDataTableListener(DataTableListener listener) {
        this.parent.addDataTableListener(listener);
    }

    void removeDataTableListener(DataTableListener listener) {
        this.parent.removeDataTableListener(listener);
    }

    public void lockRoot(int lock_key) {
        this.parent.lockRoot(lock_key);
    }

    public void unlockRoot(int lock_key) {
        this.parent.unlockRoot(lock_key);
    }

    public boolean hasRootsLocked() {
        return this.parent.hasRootsLocked();
    }

    public void printGraph(PrintStream out, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println("F[" + this.getClass());
        this.parent.printGraph(out, indent + 2);
        for (i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println("]");
    }
}

